/** @file   consts.h
 * @brief   Declaration of the constants used in the game.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/02/11 23:39:41 $
 * @author  Tomi Lamminsaari
 */
 
#ifndef H_WWW_CONSTS_H
#define H_WWW_CONSTS_H

#include <vector>
#include <string>
#include "eng2d.h"


namespace WeWantWar {



/** Consts-class holds the constants the game uses.
 *
 * This class is now quite obsole. There are still some elements but they
 * will be moved somewhere else.
 *
 * @brief     Stores the global constants of the game.
 * @author    Tomi Lamminsaari
 */
class Consts
{
public:

  ///
  /// Static members
  /// ==============
  
  /** Layers of the redraw queue
   */
  enum RedrawQueueLayers {
    ELayerKilled,
    ELayerWorms,
    ELayerNormal,
    ELayerPlayer,
    ELayerFlying,
    ELayerFlyingHigh,
    ELayerTotalCount
  };
  
  
  /** This flag controls the hash-function. */
  static const bool CHECK_HASH_CODES = false;
  
  /** Number of sectors horizontally the map has. */
  static const int SECTOR_COLUMNS = 8;
  /** Number of sector vertically the map has. */
  static const int SECTOR_ROWS = 8;
  
  /** A string that contains the version information */
  static const std::string VERSION_STR;
  /** version as float */
  static const float VERSION_NUMBER;
  
  /** Name of the highscore file */
  static const std::string HIGHSCOREFILE_NAME;
  

  /** The gravity */
  static const float GRAVITY;
  
  /** Maximum amount of bullet time. */
  static const int MAX_BULLETTIME = 300;
  
  /** Distance from player to the crosshair position in pixels when using
   * relative controls.
   */
  static const float CROSSHAIR_DISTANCE;
  
  /** Factor that defines how far the player can aim in sniper mode. */
  static const float SNIPERMODE_RANGE_FACTOR;
  
  /** This string holds the name of the temporary file we use when saving
   * the player's data between the levelchanges.
   */
  static const std::string TMPFILE_PLAYERDATA;
  
  /** Names of the saveslot-files are placed here by the 'init()'-method. */
  static std::vector<std::string> saveSlotFiles;
  
  
  ///
  /// Methods that initializes the constants
  /// ======================================
  
  /** Initializes the constants. */
  static void init();
  /** Sets up the 'saveSlotFiles'-vector. */
  static void initSaveSlots();
  

  

  Consts();
  Consts(const Consts& rO);
  ~Consts();
  Consts& operator = (const Consts& rO);

  /** Public methods **/


  /** Public GET-methods **/

private:

  /** Private methods **/


  /** Members **/

};


///
/// The timer stuff
/// ===============

/** This is the variable that will be updated in timer interupt. */
//extern volatile int timerCounter;
/** Another timer that calculates the number of updates we've done so far. */
//extern volatile unsigned int numOfUpdates;


};  // end of namespace


#endif

/**
 * Version history
 * ===============
 * $Log: consts.h,v $
 * Revision 1.2  2006/02/11 23:39:41  lamminsa
 * Bullettime shortened.
 *
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.1  2005-12-30 23:44:09+02  lamminsa
 * RedrawQueue layers added.
 *
 * Revision 1.0  2005-11-06 01:16:52+02  lamminsa
 * Initial revision
 *
 */
 

